/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CMenu.cpp,v 1.1 1999/09/12 04:29:46 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CMenu.h"

_USING_PGP

// Class CMenu member functions

void 
CMenu::GetSubMenu(PGPInt32 pos, CMenu& subMenu) const
{
	pgpAssert(IsAttached());
	
	HMENU	hSubMenu	= ::GetSubMenu(mMenu, pos);

	if (IsNull(hSubMenu))
		THROW_ERRORS(kPGPError_Win32ResourceOpFailed, GetLastError());

	subMenu.Clear();
	subMenu.Attach(hSubMenu);
}

void 
CMenu::CreatePopupMenu()
{
	Clear();
	mMenu = ::CreatePopupMenu();

	if (IsNull(mMenu))
		THROW_ERRORS(kPGPError_Win32ResourceOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CMenu::Load(HINSTANCE instance, const char *name)
{
	Clear();
	mMenu = LoadMenu(instance, name);

	if (IsNull(mMenu))
		THROW_ERRORS(kPGPError_Win32ResourceOpFailed, GetLastError());

	mWeCreated = TRUE;
}

void 
CMenu::Attach(HMENU menu)
{
	if (mMenu == menu)
		return;

	mWeCreated = FALSE;
	mMenu = menu;
}

void 
CMenu::Clear()
{
	if (WeCreated())
		DestroyMenu(mMenu);

	mWeCreated = FALSE;
	mMenu = NULL;
}
